% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_when_n_at_dose_selector.R
\name{stop_when_n_at_dose}
\alias{stop_when_n_at_dose}
\title{Stop when there are n patients at a dose.}
\usage{
stop_when_n_at_dose(parent_selector_factory, n, dose)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{n}{Stop when there are n at a dose.}

\item{dose}{\code{'any'} to stop when there are n at any dose;
\code{'recommended'} to stop when there are n at the recommended dose; or an
integer to stop when there are n at a particular dose-level.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method stops a dose-finding trial when there are n patients at a dose.
It can stop when the rule is triggered at the recommended dose, at a
particular dose, or at any dose.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25

# This model will stop when 12 are seen at any dose:
model1 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_when_n_at_dose(n = 12, dose = 'any')

# This model fit will not stop:
model1 \%>\% fit('1NNN 2NTN 2TNN 2NNN') \%>\% continue()
# But this model fit will stop:
model1 \%>\% fit('1NNN 2NTN 2TNN 2NNN 2NTT') \%>\% continue()

# This model will stop when 12 are seen at the recommended dose:
model2 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_when_n_at_dose(n = 12, dose = 'recommended')

# This model fit will not stop:
fit2 <- model2 \%>\% fit('1NNN 2NTN 2TNN 2NNN')
fit2 \%>\% recommended_dose()
fit2 \%>\% continue()
# But this model fit will stop:
fit3 <- model2 \%>\% fit('1NNN 2NTN 2TNN 2NNN 2NNT')
fit3 \%>\% recommended_dose()
fit3 \%>\% continue()
}
