#' Holzinger and Swineford (1939) cognitive tests data in 301 children from two schools
#'
#' This classic data set contains reported data on cognitive tests from two elementary schools.
#'
#' 11 variables used in Deng and Yuan (2016) are included in this version of data, they are: visual perception, cubes, paper form board, paragraph comprehension, word classification, word meaning, counting dots, straight-curved capitals, deduction, problem reasoning, and series completion.
#'
#' This data set with more variables are available in other R packages such as lavaan, and OpenMX.
#'
#' @usage data(HolzingerSwineford)
#'
#' @format A data frame with 301 observations on 11 numeric variables and a group indicator (12 variables in total).
#'
#' @seealso \code{\link[lavaan]{HolzingerSwineford1939}}, \code{\link[OpenMx]{HS.ability.data}}
#' @keywords HS
#'
#' @references Deng, L., & Yuan, K. H. (2016). Comparing Latent Means Without Mean Structure Models: A Projection-Based Approach. Psychometrika, 81(3), 802-829.
#' @references Yuan, K. H., & Chan, W. (2016). Measurement invariance via multigroup SEM: Issues and solutions with chi-square-difference tests. Psychological methods, 21(3), 405-426.
#'
#' @examples
#' data(HolzingerSwineford)
"HolzingerSwineford"

