% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5dcw.R
\name{eq5dcw}
\alias{eq5dcw}
\title{Calculate EQ-5D-5L crosswalk index scores}
\usage{
eq5dcw(scores, country = "UK")
}
\arguments{
\item{scores}{numeric with names MO, SC, UA, PD and AD representing
Mobility, Self-care, Usual activities, Pain/discomfort and Anxiety/depression.}

\item{country}{value set country.}
}
\value{
calculated utility index score.
}
\description{
Calculate indices for EQ-5D-5L indices by mapping them onto EQ-5D-3L value sets.
Available value sets can be viewed using the function \code{valuesets}.
}
\examples{
eq5dcw(scores=c(MO=1,SC=2,UA=5,PD=1,AD=3), country="UK")
eq5dcw(scores=c(MO=3,SC=5,UA=5,PD=2,AD=3), country="Germany")

}
