% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scc.R
\name{necessary_causes}
\alias{necessary_causes}
\title{Extract necessary causes}
\usage{
necessary_causes(scc, output = c("id", "desc", "desc_no_start"))
}
\arguments{
\item{scc}{An object of class \code{epicmodel_scc}.}

\item{output}{A single element of type character determining the type of output. Either \code{id} (default), \code{desc}, or \code{desc_no_start}. See
section "Value" below for a description of the output.}
}
\value{
A character vector containing all necessary causes. Depending on the value of \code{output}, the vector contains either step IDs
(\code{output = "id"}), step descriptions (\code{output = "desc"}), or step descriptions but with the "Start: " in the beginning removed
(\code{output = "desc_no_start"}).
}
\description{
Necessary causes are component causes, which are part of every sufficient cause and, therefore, have to be present in order for the outcome
to occur.
}
\examples{
necessary_causes(scc_rain)
}
