% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q-matrix.R
\name{q_matrix}
\alias{q_matrix}
\title{Create a Q Matrix Object}
\usage{
q_matrix(x)
}
\arguments{
\item{x}{Either a \code{data.frame} or \code{matrix}.}
}
\value{
A \code{q_matrix} object.
}
\description{
Provides a way to create an object as a \code{"q_matrix"}.
}
\examples{
# Q matrix values
x = matrix(c(1, 0, 0, 1), nrow = 2)

# Q matrix wrapper
q_mat = q_matrix(x)

# Data Frame encoding of Q
q_df = data.frame(
   k1 = c(1, 0),
   k2 = c(0, 1)
)

# Create a Q matrix
q_mat = q_matrix(q_df)
}
\seealso{
\code{\link[=as_q_matrix]{as_q_matrix()}}
}
