% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_imp.R
\name{plot_imp}
\alias{plot_imp}
\title{plot feature importance}
\usage{
plot_imp(p, data_input, truncate_at = 50, color = "darkgrey")
}
\arguments{
\item{p}{alluvial plot}

\item{data_input}{dataframe used to generate alluvial plot}

\item{truncate_at}{integer, limit number of features to that value, Default: 50}

\item{color}{character vector, Default: 'darkgrey'}
}
\value{
ggplot object
}
\description{
plot important features of model response alluvial as bars
}
\examples{
\dontrun{
df = mtcars2[, ! names(mtcars2) \%in\% 'ids' ]

train = caret::train( disp ~ .
                     , df
                     , method = 'rf'
                     , trControl = caret::trainControl( method = 'none' )
                     , importance = TRUE )

pred_train = caret::predict.train(train, df)

p = alluvial_model_response_caret(train, degree = 3, pred_train = pred_train)

plot_imp(p, mtcars2)

}
}
