% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_head-rd.R, R/slice_head.R
\name{slice_head.duckplyr_df}
\alias{slice_head.duckplyr_df}
\title{Subset rows using their positions}
\usage{
\method{slice_head}{duckplyr_df}(.data, ..., n, prop, by = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{For \code{slice()}: <\code{\link[rlang:args_data_masking]{data-masking}}>
Integer row values.

Provide either positive values to keep, or negative values to drop.
The values provided must be either all positive or all negative.
Indices beyond the number of rows in the input are silently ignored.

For \verb{slice_*()}, these arguments are passed on to methods.}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used. If \code{n} is greater than the number of rows in the group
(or \code{prop > 1}), the result will be silently truncated to the group size.
\code{prop} will be rounded towards zero to generate an integer number of
rows.

A negative value of \code{n} or \code{prop} will be subtracted from the group
size. For example, \code{n = -2} with a group of 5 rows will select 5 - 2 = 3
rows; \code{prop = -0.25} with 8 rows will select 8 * (1 - 0.25) = 6 rows.}

\item{by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}
}
\description{
This is a method for the \code{\link[dplyr:slice]{dplyr::slice_head()}} generic.
\code{slice_head()} selects the first rows.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{slice_head.duckplyr_df()}
\itemize{
\item if \code{by} or \code{prop} is provided,
\item with a negative \code{n}.
}

These features fall back to \code{\link[dplyr:slice]{dplyr::slice_head()}}, see \code{vignette("fallback")} for details.
}

\examples{
library(duckplyr)
df <- data.frame(x = 1:3)
df <- slice_head(df, n = 2)
df
}
\seealso{
\code{\link[dplyr:slice]{dplyr::slice_head()}}
}
