% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec.R
\name{db_exec}
\alias{db_exec}
\title{Execute a statement for the default connection}
\usage{
db_exec(sql, ..., con = NULL)
}
\arguments{
\item{sql}{The statement to run.}

\item{...}{These dots are for future extensions and must be empty.}

\item{con}{The connection, defaults to the default connection.}
}
\value{
The return value of the \code{\link[DBI:dbExecute]{DBI::dbExecute()}} call, invisibly.
}
\description{
The \pkg{duckplyr} package relies on a DBI connection
to an in-memory database.
The \code{db_exec()} function allows running SQL statements
with side effects on this connection.
It can be used to execute statements that start with
\code{PRAGMA}, \code{SET}, or \code{ATTACH}
to, e.g., set up credentials, change configuration options,
or attach other databases.
See \url{https://duckdb.org/docs/configuration/overview.html}
for more information on the configuration options,
and \url{https://duckdb.org/docs/sql/statements/attach.html}
for attaching databases.
}
\examples{
db_exec("SET threads TO 2")
}
\seealso{
\code{\link[=read_sql_duckdb]{read_sql_duckdb()}}
}
