% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NegativeBinomial.R
\name{pdf.NegativeBinomial}
\alias{pdf.NegativeBinomial}
\alias{log_pdf.NegativeBinomial}
\title{Evaluate the probability mass function of a NegativeBinomial distribution}
\usage{
\method{pdf}{NegativeBinomial}(d, x, drop = TRUE, elementwise = NULL, ...)

\method{log_pdf}{NegativeBinomial}(d, x, drop = TRUE, elementwise = NULL, ...)
}
\arguments{
\item{d}{A \code{NegativeBinomial} object created by a call to
\code{\link[=NegativeBinomial]{NegativeBinomial()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{elementwise}{logical. Should each distribution in \code{d} be evaluated
at all elements of \code{x} (\code{elementwise = FALSE}, yielding a matrix)?
Or, if \code{d} and \code{x} have the same length, should the evaluation be
done element by element (\code{elementwise = TRUE}, yielding a vector)? The
default of \code{NULL} means that \code{elementwise = TRUE} is used if the
lengths match and otherwise \code{elementwise = FALSE} is used.}

\item{...}{Arguments to be passed to \code{\link[stats]{dnbinom}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the probability mass function of a NegativeBinomial distribution
}
\examples{

set.seed(27)

X <- NegativeBinomial(size = 5, p = 0.1)
X

random(X, 10)

pdf(X, 50)
log_pdf(X, 50)

cdf(X, 50)
quantile(X, 0.7)

## alternative parameterization of X
Y <- NegativeBinomial(mu = 45, size = 5)
Y
cdf(Y, 50)
quantile(Y, 0.7)
}
\seealso{
Other NegativeBinomial distribution: 
\code{\link{cdf.NegativeBinomial}()},
\code{\link{quantile.NegativeBinomial}()},
\code{\link{random.NegativeBinomial}()}
}
\concept{NegativeBinomial distribution}
