% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{pdf.Weibull}
\alias{pdf.Weibull}
\alias{log_pdf.Weibull}
\title{Evaluate the probability mass function of a Weibull distribution}
\usage{
\method{pdf}{Weibull}(d, x, drop = TRUE, elementwise = NULL, ...)

\method{log_pdf}{Weibull}(d, x, drop = TRUE, elementwise = NULL, ...)
}
\arguments{
\item{d}{A \code{Weibull} object created by a call to \code{\link[=Weibull]{Weibull()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{elementwise}{logical. Should each distribution in \code{d} be evaluated
at all elements of \code{x} (\code{elementwise = FALSE}, yielding a matrix)?
Or, if \code{d} and \code{x} have the same length, should the evaluation be
done element by element (\code{elementwise = TRUE}, yielding a vector)? The
default of \code{NULL} means that \code{elementwise = TRUE} is used if the
lengths match and otherwise \code{elementwise = FALSE} is used.}

\item{...}{Arguments to be passed to \code{\link[stats]{dweibull}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Please see the documentation of \code{\link[=Weibull]{Weibull()}} for some properties
of the Weibull distribution, as well as extensive examples
showing to how calculate p-values and confidence intervals.
}
\examples{

set.seed(27)

X <- Weibull(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other Weibull distribution: 
\code{\link{cdf.Weibull}()},
\code{\link{quantile.Weibull}()},
\code{\link{random.Weibull}()}
}
\concept{Weibull distribution}
