% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coerce.R, R/summary.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{as.data.frame,MultivariateSummary-method}
\alias{summary,CA-method}
\alias{summary,PCA-method}
\title{Object Summaries}
\usage{
\S4method{as.data.frame}{MultivariateSummary}(x, row.names = NULL, optional = FALSE, ...)

\S4method{summary}{CA}(
  object,
  ...,
  axes = c(1, 2),
  margin = 1,
  active = TRUE,
  sup = TRUE,
  rank = NULL
)

\S4method{summary}{PCA}(
  object,
  ...,
  axes = c(1, 2),
  margin = 1,
  active = TRUE,
  sup = TRUE,
  rank = NULL
)
}
\arguments{
\item{x}{A \code{\linkS4class{MultivariateSummary}} object.}

\item{row.names}{A \code{\link{character}} vector giving the row names for the data
frame, or \code{NULL}.}

\item{optional}{A \code{\link{logical}} scalar: should the names of the variables in
the data frame be checked? If \code{FALSE} then the names of the variables in the
data frame are checked to ensure that they are syntactically valid variable
names and are not duplicated.}

\item{...}{Currently not used.}

\item{object}{A \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions to be
summarized.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be summarized: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
summarized?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
summarized?}

\item{rank}{An \code{\link{integer}} value specifying the maximal number of components
to be kept in the results. Deprecated, use \code{axes} instead.}
}
\description{
Provides a summary of the results of a multivariate data analysis.
}
\examples{
## Data from Lebart et al. 2006, p. 170-172
data("colours")

## Compute correspondence analysis
X <- ca(colours)

## Rows summary
summary(X, margin = 1)

## Columns summary
summary(X, margin = 2)
}
\seealso{
Other summary: 
\code{\link{describe}()},
\code{\link{tidy}()}
}
\author{
N. Frerebeau
}
\concept{summary}
