% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preconditionChecks.R
\name{uniformize.data}
\alias{uniformize.data}
\title{Standardize data format}
\usage{
uniformize.data(
  data,
  admin = FALSE,
  conf = FALSE,
  comp.risks = FALSE,
  Zbin = NULL,
  Wbin = NULL
)
}
\arguments{
\item{data}{A data frame that should contain columns named \code{Y} and
\code{delta} (unless \code{comp.risks = TRUE}, see later).}

\item{admin}{Boolean value indicating whether the provided data frame contains
administrative (i.e. independent) censoring on top of the dependent censoring
(in the column named \code{delta}). The default is \code{admin = FALSE}.}

\item{conf}{Boolean value indicating whether the provided data frame contains
a confounded variable and a corresponding instrument. If \code{cond = TRUE},
the provided data frame should contain columns named \code{Z} and \code{W},
corresponding to the confounded variable and instrument, respectively.
Moreover, \code{Zbin} and \code{Wbin} should be specified. The default value
is \code{conf = FALSE}.}

\item{comp.risks}{Boolean value indicating whether the provided data frame
contains competing risks. If \code{comp.risks = TRUE}, the given data frame
should contain the columns \code{delta1}, \code{delta2}, etc., corresponding
to the indicators I(Y = T1), I(Y = T2), etc. respectively. The default is
\code{comp.risks = FALSE}.}

\item{Zbin}{Boolean or integer value (0, 1) indicating whether the confounded
variable is binary. \code{Zbin = TRUE} or \code{Zbin = 1} means that Z is
binary. \code{Zbin = FALSE} or \code{Zbin = 0} means that Z is continuous.}

\item{Wbin}{Boolean or integer value (0, 1) indicating whether the instrument
is binary. \code{Wbin = TRUE} or \code{Wbin = 1} means that W is binary.
\code{Wbin = FALSE} or \code{Wbin = 0} means that W is continuous.}
}
\value{
Returns the uniformized data set.
}
\description{
Checks the required preconditions of the data and possibly
restructures the data.
}
