% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{EAM}
\alias{EAM}
\title{Main function to run the EAM algorithm}
\usage{
EAM(
  dir,
  test.fun,
  hyperparams,
  evaluations = NULL,
  time.run.duration = FALSE,
  verbose = 0,
  picturose = FALSE
)
}
\arguments{
\item{dir}{The direction of the test. \code{dir = 1} corresponds to finding
the upper bound of the identified set, \code{dir = -1} corresponds to finding
the lower bound.}

\item{test.fun}{The test function to be inverted in order to obtain the
identified set. It should take a scalar parameter as argument (i.e. the
specified value of a component of the full parameter vector) and return a
list with named elements \code{list(theta, t.stat, crit.val)}, where
\code{theta} is the scalar value that was tested, \code{t.stat} is the value
of the test statistic and \code{crit.val} is the critical value to be used in
determining whether to reject or not reject.}

\item{hyperparams}{A list of hyperparameters needed in order for this method
to run (see \code{set.EAM.hyperparameters.R}).}

\item{evaluations}{Matrix of already evaluated points, of which at least one
is feasible. When \code{evaluations = NULL} (default), the initial feasible
point search will be executed first.}

\item{time.run.duration}{Boolean value indicating whether to time each step
in the EAM algorithm. Requires \code{chronometer.R}. Default is
\code{time.run.duration = FALSE}.}

\item{verbose}{Boolean value indicating whether or not to print run time
updates to the console. Default is \code{verbose = FALSE}.}

\item{picturose}{Boolean value indicating whether or not to visualize the
identified set search. Default is \code{picturose = FALSE}.}
}
\value{
List containing the evaluations of the test statistic and critical
values, convergence information, and run times.
}
\description{
This function implements the EAM search strategy as described in
Kaido, Molinari and Stoye (2019). This is a generic function, requiring the
specification of a test function (\code{test.fun}), as well as the
specification of the parameter space (\code{hyperparams}).
}
\references{
Kaido et al. (2019). Confidence intervals for projections of
partially identified parameters. Econometrica. 87(4):1397-1432.
}
