% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_dbscan.R
\name{cluster_dbscan}
\alias{cluster_dbscan}
\title{DBSCAN}
\usage{
cluster_dbscan(minPts = 3, eps = NULL)
}
\arguments{
\item{minPts}{minimum number of points}

\item{eps}{distance value}
}
\value{
returns a dbscan object
}
\description{
Density-Based Spatial Clustering of Applications with Noise using \code{dbscan::dbscan}.
}
\details{
Discovers clusters as dense regions separated by sparse areas. Hyperparameters are \code{eps} (neighborhood radius)
and \code{minPts} (minimum points). If \code{eps} is missing, it is estimated from the kNN distance curve elbow.
}
\examples{
# setup clustering
model <- cluster_dbscan(minPts = 3)

#load dataset
data(iris)

# build model
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)

# evaluate model using external metric
eval <- evaluate(model, clu, iris$Species)
eval
}
\references{
Ester, M., Kriegel, H.-P., Sander, J., Xu, X. (1996). A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise.
}
