% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.classo.R
\name{plot.cv.classo}
\alias{plot.cv.classo}
\title{plot the cross-validation curve produced by cv.classo}
\usage{
\method{plot}{cv.classo}(x, sign.lambda = 1, ...)
}
\arguments{
\item{x}{fitted \code{"cv.classo"} object}

\item{sign.lambda}{Either plot against \code{log(lambda)} (default) or its
negative if \code{sign.lambda=-1}.}

\item{\dots}{Other graphical parameters to plot.}
}
\value{
No return value, called for side effects (produces a plot).
}
\description{
Plots the cross-validation curve, and upper and lower standard deviation
curves, as a function of the \code{lambda} values used.
}
\details{
A plot is produced, and nothing is returned.
}
\examples{
\donttest{ 
set.seed(1010)
n = 1000
p = 200
x = array(rnorm(n*p), c(n,p)) + (1+1i) * array(rnorm(n*p), c(n,p))
for (j in 1:p) x[,j] = x[,j] / sqrt(mean(Mod(x[,j])^2))
e = rnorm(n) + (1+1i) * rnorm(n)
b = c(1, -1, rep(0, p-2)) + (1+1i) * c(-0.5, 2, rep(0, p-2))
y = x \%*\% b + e
cv.test = cv.classo(x,y)
plot(cv.test)
}
}
\seealso{
\code{classo} and \code{plot} methods for \code{"cv.classo"}.
}
\author{
Navonil Deb, Younghoon Kim, Sumanta Basu \cr Maintainer: Younghoon Kim
\email{yk748@cornell.edu}
}
