% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_ma.R
\name{sma}
\alias{sma}
\title{Add Simple Moving Average (SMA) indicators to the chart}
\usage{
sma(
 price  = "close",
 n      = 10,
 ...
)
}
\arguments{
\item{price}{A \link{character}-vector of \link{length} 1. "close" by default.
The name of the vector to passed into \code{\link[TTR:SMA]{TTR::SMA()}}.}

\item{n}{Number of periods to average over. Must be between 1 and
\code{nrow(x)}, inclusive.}

\item{...}{For internal use. Please ignore.}
}
\value{
A \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:add_lines]{plotly::add_lines()}}-wrapper function that
interacts with \{TTR\}'s moving average family of functions.
The function adds moving average indicators to the main \code{\link[=chart]{chart()}}.
}
\examples{
# script start;

cryptoQuotes::chart(
  ticker = BTC,
  main   = kline(),
  indicator = list(
    cryptoQuotes::ema(n = 7),
    cryptoQuotes::sma(n = 14),
    cryptoQuotes::wma(n = 21)
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other moving average indicators: 
\code{\link{alma}()},
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other main chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{main chart indicators}
\concept{moving average indicators}
