% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{Simulations-class}
\alias{Simulations-class}
\alias{.Simulations}
\alias{Simulations}
\alias{.DefaultSimulations}
\title{\code{Simulations}}
\usage{
Simulations(fit, stop_reasons, stop_report, additional_stats, ...)

.DefaultSimulations()
}
\arguments{
\item{fit}{(\code{list})\cr see slot definition.}

\item{stop_reasons}{(\code{list})\cr see slot definition.}

\item{stop_report}{see \code{\link{Simulations}}}

\item{additional_stats}{(\code{list})\cr see slot definition.}

\item{\dots}{additional parameters from \code{\link{GeneralSimulations}}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This class captures the trial simulations from model based designs.
Additional slots \code{fit}, \code{stop_reasons}, \code{stop_report},\code{additional_stats} compared to
the general class \code{\link{GeneralSimulations}}.
}
\section{Slots}{

\describe{
\item{\code{fit}}{(\code{list})\cr final fits}

\item{\code{stop_reasons}}{(\code{list})\cr stopping reasons for each simulation run}

\item{\code{stop_report}}{matrix of stopping rule outcomes}

\item{\code{additional_stats}}{list of additional statistical summary}
}}

\note{
Typically, end users will not use the \code{.DefaultSimulations()} function.
}
\examples{
data <- list(
  Data(
    x = 1:2,
    y = 0:1,
    doseGrid = 1:2,
    ID = 1L:2L,
    cohort = 1L:2L
  ),
  Data(
    x = 3:4,
    y = 0:1,
    doseGrid = 3:4,
    ID = 1L:2L,
    cohort = 1L:2L
  )
)

doses <- c(1, 2)

seed <- as.integer(123)

fit <- list(
  c(0.1, 0.2),
  c(0.3, 0.4)
)

stop_report <- matrix(c(TRUE, FALSE), nrow = 2)

stop_reasons <- list("A", "B")

additional_stats <- list(a = 1, b = 1)

simulations <- Simulations(
  fit = fit,
  stop_report = stop_report,
  stop_reasons = stop_reasons,
  additional_stats = additional_stats,
  data,
  doses,
  seed
)
}
