% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_shift.R
\name{tbl_shift}
\alias{tbl_shift}
\alias{add_overall.tbl_shift}
\title{Shift Table}
\usage{
tbl_shift(
  data,
  variable,
  strata = NULL,
  by = NULL,
  data_header = NULL,
  strata_location = c("new_column", "header"),
  strata_label = "{strata}",
  header = "{level}  \\nN = {n}",
  label = NULL,
  nonmissing = "always",
  nonmissing_text = "Total",
  ...
)

\method{add_overall}{tbl_shift}(
  x,
  col_label = "All Participants  \\n(N = {gtsummary::style_number(n)})",
  last = FALSE,
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr A data frame.}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable to tabulate. Typically the post-baseline grade.}

\item{strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Stratifying variable. Typically the baseline grade.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable to report results by. Typical value is the treatment arm.}

\item{data_header}{(\code{data.frame})\cr
Data frame used to calculate the Ns in the table header.
Only include the columns needed to merge with \code{data}: these are typically
the \code{'USUBJID'} and the treatment arm only, e.g \code{ADSL[c("USUBJID", "ARM")]}.}

\item{strata_location}{(\code{string})\cr
Specifies the location where the individual stratum levels will be printed.
Must be one of \code{c("new_column", "header")}.
\code{"new_column"}: stratum labels are placed in a new column to the left of the tabulated results.
\code{"header"}: stratum labels are placed in a header row above the tabulations.}

\item{strata_label}{(\code{string})\cr
A glue-string that inserts stratum level. Default is \code{'{strata}'}, and
\code{{n}} is also available to insert.}

\item{header}{(\code{string})\cr
String that is passed to \code{gtsummary::modify_header(all_stat_cols() ~ header)}.}

\item{label}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Used to specify the labels for the \code{strata} and \code{variable} columns.
Default is to use the column label attribute.}

\item{nonmissing, nonmissing_text, ...}{Argument passed to \code{tbl_roche_summary()}.
See details below for call details to \code{tbl_roche_summary()}.}

\item{x}{(\code{tbl_shift})\cr
Object of class \code{'tbl_shift'}.}

\item{col_label}{(\code{string})\cr
String indicating the column label. Default is \code{"All Participants \\nN = {gtsummary::style_number(n)}"}}

\item{last}{(scalar \code{logical})\cr
Logical indicator to display overall column last in table.
Default is \code{FALSE}, which will display overall column first.}
}
\value{
a 'gtsummary' table
}
\description{
Typical use is tabulating post-baseline measurement stratified by the
baseline measurement.
}
\details{
Broadly, this function is a wrapper for chunk below with some additional
calls to \verb{gtsummary::modify_*()} function to update the table's
headers, indentation, column alignment, etc.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtsummary::tbl_strata2(
  data = data,
  strata = strata,
   ~ tbl_roche_summary(.x, include = variable, by = by)
)
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr, warn.conflicts = FALSE)

# subsetting ADLB on one PARAM, and the highest grade
adlb <- pharmaverseadam::adlb |>
  select("USUBJID", "TRT01A", "PARAM", "PARAMCD", "ATOXGRH", "BTOXGRH", "VISITNUM") |>
  mutate(TRT01A = factor(TRT01A)) |>
  filter(PARAMCD \%in\% c("CHOLES", "GLUC")) |>
  slice_max(by = c(USUBJID, PARAMCD), order_by = ATOXGRH, n = 1L, with_ties = FALSE) |>
  labelled::set_variable_labels(
    BTOXGRH = "Baseline  \nNCI-CTCAE Grade",
    ATOXGRH = "Post-baseline  \nNCI-CTCAE Grade"
  )
adsl <- pharmaverseadam::adsl[c("USUBJID", "TRT01A")] |>
  filter(TRT01A != "Screen Failure")

# Example 1 ----------------------------------
# tabulate baseline grade by worst grade
tbl_shift(
  data = filter(adlb, PARAMCD \%in\% "CHOLES"),
  strata = BTOXGRH,
  variable = ATOXGRH,
  by = TRT01A,
  data_header = adsl
)

# Example 2 ----------------------------------
# same as Ex1, but with the stratifying variable levels in header rows
adlb |>
  filter(PARAMCD \%in\% "CHOLES") |>
  labelled::set_variable_labels(
    BTOXGRH = "Baseline NCI-CTCAE Grade",
    ATOXGRH = "Post-baseline NCI-CTCAE Grade"
  ) |>
  tbl_shift(
    data = ,
    strata = BTOXGRH,
    variable = ATOXGRH,
    strata_location = "header",
    by = TRT01A,
    data_header = adsl
  )

# Example 3 ----------------------------------
# same as Ex2, but with two labs
adlb |>
  labelled::set_variable_labels(
    BTOXGRH = "Baseline NCI-CTCAE Grade",
    ATOXGRH = "Post-baseline NCI-CTCAE Grade"
  ) |>
  tbl_strata_nested_stack(
    strata = PARAM,
    ~ .x |>
      tbl_shift(
        strata = BTOXGRH,
        variable = ATOXGRH,
        strata_location = "header",
        by = TRT01A,
        data_header = adsl
      )
  ) |>
  # Update header with Lab header and indentation (the '\U00A0' character adds whitespace)
  modify_header(
    label = "Lab  \n\U00A0\U00A0\U00A0\U00A0
             Baseline NCI-CTCAE Grade  \n\U00A0\U00A0\U00A0\U00A0\U00A0\U00A0\U00A0\U00A0
             Post-baseline NCI-CTCAE Grade"
  )

# Example 4 ----------------------------------
# Include the treatment variable in a new column
filter(adlb, PARAMCD \%in\% "CHOLES") |>
  right_join(
    pharmaverseadam::adsl[c("USUBJID", "TRT01A")] |>
      filter(TRT01A != "Screen Failure"),
    by = c("USUBJID", "TRT01A")
  ) |>
  tbl_shift(
    strata = TRT01A,
    variable = BTOXGRH,
    by = ATOXGRH,
    header = "{level}",
    strata_label = "{strata}, N={n}",
    label = list(TRT01A = "Actual Treatment"),
    percent = "cell",
    nonmissing = "no"
  ) |>
  modify_spanning_header(all_stat_cols() ~ "Worst Post-baseline NCI-CTCAE Grade")
\dontshow{\}) # examplesIf}
}
