% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srcrefs.R
\name{srcrefs}
\alias{srcrefs}
\alias{srcrefs.default}
\alias{srcrefs.list}
\alias{srcrefs.namespace}
\alias{srcrefs.environment}
\alias{srcrefs.R6ClassGenerator}
\alias{srcrefs.standardGeneric}
\alias{srcrefs.nonstandardGenericFunction}
\alias{srcrefs.MethodDefinition}
\title{Retrieve \code{srcref}s}
\usage{
srcrefs(x, ...)

\method{srcrefs}{default}(x, ..., srcref_names = NULL, breadcrumbs = character())

\method{srcrefs}{list}(x, ..., srcref_names = NULL, breadcrumbs = character())

\method{srcrefs}{namespace}(x, ..., breadcrumbs = character())

\method{srcrefs}{environment}(x, ..., breadcrumbs = character())

\method{srcrefs}{R6ClassGenerator}(x, ..., srcref_names = NULL, breadcrumbs = character())

\method{srcrefs}{standardGeneric}(x, ..., srcref_names = NULL)

\method{srcrefs}{nonstandardGenericFunction}(x, ..., srcref_names = NULL)

\method{srcrefs}{MethodDefinition}(x, ..., srcref_names = NULL)
}
\arguments{
\item{x}{An object to source srcrefs from}

\item{...}{Additional arguments passed to methods}

\item{srcref_names}{An optional field used to supercede any discovered object
names when choosing which names to provide in the returned list.}

\item{breadcrumbs}{Recursive methods are expected to propegate a vector of
"breadcrumbs" (a character vector of namespace names encountered while
traversing the namespace used as a memory of what we've seen already),
which is used for short-circuiting recursive environment traversal.}
}
\value{
A \code{list} of \code{srcref} objects. Often, has a length of 1, but can be
larger for things like environments, namespaces or generic methods. The
names of the list reflect the name of the Rd name or alias that could be
used to find information related to each \code{srcref}. Elements of the \code{list}
will have attribute \code{"namespace"} denoting the source environment namespace
if one can be determined for the srcref object.
}
\description{
This function takes a code collection and returns a \code{list} of related
\code{srcref} objects with \code{list} names that associate the \code{srcref} with a name or
alias that could be used to find documentation. Code collections include
structures such as package namespaces, environments, function definitions,
methods tables or class generators - any object which enapsulates a single or
set of \code{srcref} objects.
}
\details{
For most objects, this is a one-to-one mapping of exported object names to
their \code{srcref}, just like you would get using \code{getNamespace()}. However, for
classes and methods, this can be a one-to-many mapping of related
documentation to the multiple \code{srcref}s that are described there. This is the
case for S3 generics, S4 objects and R6 objects.

Objects without any related \code{srcref}s, such as any datasets or objects
created at package build time will be omitted from the results.
}
\examples{
# examples use `with` to execute within namespace as function isn't exported
ns <- getNamespace("covtracer")

# load and extract srcrefs for a package
with(ns, srcrefs(getNamespace("covtracer")))

# extract srcrefs for functions
with(ns, srcrefs(srcrefs))

}
