% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_prob_functions.R
\name{ppfunc.mat}
\alias{ppfunc.mat}
\title{Find PPs of SNPs from matrix of Z-scores}
\usage{
ppfunc.mat(zstar, V, W = 0.2)
}
\arguments{
\item{zstar}{Matrix of marginal z-scores, one replicate per row}

\item{V}{Variance of the estimated effect size, one element per column of zstar}

\item{W}{Prior for the standard deviation of the effect size parameter, beta}
}
\value{
Matrix of posterior probabilities of causality
}
\description{
Posterior probabilities of causality from matrix of marginal Z-scores (1 simulation per row)
}
\details{
This function converts a matrix of Z-scores (one row per simulation) to posterior probabilities of causality,
not including the null model of no genetic effects,
so that the sum of the posterior probabilities for each simulation (each row) is 1.
}
\examples{

set.seed(1)
nsnps = 100
N0 = 5000
N1 = 5000

## generate example LD matrix and MAFs
library(mvtnorm)
nsamples = 1000

simx <- function(nsnps, nsamples, S, maf=0.1) {
    mu <- rep(0,nsnps)
    rawvars <- rmvnorm(n=nsamples, mean=mu, sigma=S)
    pvars <- pnorm(rawvars)
    x <- qbinom(1-pvars, 1, maf)
}

S <- (1 - (abs(outer(1:nsnps,1:nsnps,`-`))/nsnps))^4
X <- simx(nsnps,nsamples,S)
maf <- colMeans(X)

varbeta <- Var.data.cc(f = maf, N = N0+N1, s = N1/(N0+N1))

# simulate matrix of Z scores
# 1 simulation per row
z_scores <- matrix(rnorm(nsnps*100, 0, 3), ncol = nsnps)

# each row is a vector of simulated PPs
res <- ppfunc.mat(zstar = z_scores, V = varbeta)

rowSums(res)

}
\author{
Chris Wallace
}
