% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{delete_integration}
\alias{delete_integration}
\title{Delete an OAuth integration}
\usage{
delete_integration(integration)
}
\arguments{
\item{integration}{A \code{connect_integration} object (as returned by \code{\link[=get_integrations]{get_integrations()}},
\code{\link[=get_integration]{get_integration()}}, or \code{\link[=create_integration]{create_integration()}}).}
}
\value{
Returns \code{NULL} invisibly if successful.
}
\description{
Deletes an OAuth integration from the Posit Connect server. This permanently
removes the integration and any associated content associations.

You must have administrator privileges to perform this action.

See the Posit Connect documentation on
\href{https://docs.posit.co/connect/admin/integrations/oauth-integrations/}{OAuth integrations} for
more information.
}
\examples{
\dontrun{
client <- connect()

# Get an integration to delete
integration <- get_integration(client, "your-integration-guid")

# Delete the integration
delete_integration(integration)
}

}
\seealso{
\code{\link[=get_integrations]{get_integrations()}}, \code{\link[=get_integration]{get_integration()}}, \code{\link[=create_integration]{create_integration()}},
\code{\link[=update_integration]{update_integration()}}

Other oauth integration functions: 
\code{\link{create_integration}()},
\code{\link{get_associations}()},
\code{\link{get_integration}()},
\code{\link{get_integrations}()},
\code{\link{set_integrations}()},
\code{\link{update_integration}()}
}
\concept{oauth integration functions}
