% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidenceCurves.R
\name{testConfidenceCurves}
\alias{testConfidenceCurves}
\title{Test confidence curves}
\usage{
testConfidenceCurves(
  num.ctrl = 50,
  num.trmt = 50,
  vary.ctrl = seq(16, 20, by = 2),
  vary.trmt = seq(26, 30, by = 2),
  vary.lmb = c(-0.05, -0.1),
  estimate.type = "odds ratio",
  return.plot = TRUE,
  save.plot = FALSE,
  directory = "./test"
)
}
\arguments{
\item{num.ctrl}{Number of subjects in control group. Default is 50.}

\item{num.trmt}{Number of subjects in treatment group. Default is 50.}

\item{vary.ctrl}{List of numbers to vary response in control group. Default is c(16, 18, 20).}

\item{vary.trmt}{List of numbers to vary response in treatment group. Default is c(26, 28,30).}

\item{vary.lmb}{List of numbers to vary definition of meaningful benefit. Default is c(-0.05, -0.1).}

\item{estimate.type}{Type of estimator, options are "risk difference" and "odds ratio" (default).}

\item{return.plot}{Return and print the CFD plot. TRUE (default) or FALSE.}

\item{save.plot}{Save the family of confidence curves to directory. TRUE or FALSE (default).}

\item{directory}{Location to save images. Default is './test'.}
}
\value{
Returns a dataframe
}
\description{
A short function to test makeConfidenceCurves for binary data
}
\examples{
# to fix control and treatment responders
testConfidenceCurves(vary.lmb = c(-0.05, -0.1), vary.ctrl = c(18), vary.trmt = c(28))
# to run without showing plots
testConfidenceCurves(
vary.lmb = c(-0.05, -0.1),
vary.ctrl = c(18),
vary.trmt = c(28),
return.plot=FALSE)
}
