% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecometric_space.R
\name{ecometric_space}
\alias{ecometric_space}
\title{Plot ecometric space for quantitative environmental variables}
\usage{
ecometric_space(
  model_out,
  env_name = "env_var",
  fossil_data = NULL,
  fossil_color = "#000000",
  modern_color = "#bc4749",
  palette = c("#bc6c25", "#fefae0", "#606c38"),
  x_label = "Summary metric 1",
  y_label = "Summary metric 2"
)
}
\arguments{
\item{model_out}{Output from \code{ecometric_model()}, containing environmental estimates in trait space.}

\item{env_name}{Name to display for the environmental variable (used in the legend title).}

\item{fossil_data}{Optional. Output from \code{reconstruct_env()}.}

\item{fossil_color}{Outline color for fossil data bins (default: \code{"#000000"}).}

\item{modern_color}{Outline color for modern data bins (default: \code{"#bc4749"}).}

\item{palette}{Vector of colors to use for the gradient scale representing environmental values.}

\item{x_label}{Label for the x-axis in the output plots (default: "Summary metric 1").}

\item{y_label}{Label for the y-axis in the output plots (default: "Summary metric 2").}
}
\value{
A ggplot2 object visualizing the ecometric trait-environment surface.
}
\description{
Visualizes the ecometric space for quantitative environmental variables
based on the output from \code{ecometric_model()}.
}
\examples{
\donttest{
# Load internal data
data("geoPoints", package = "commecometrics")
data("traits", package = "commecometrics")
data("spRanges", package = "commecometrics")
data("fossils", package = "commecometrics")

# Summarize trait values at sampling points
traitsByPoint <- summarize_traits_by_point(
  points_df = geoPoints,
  trait_df = traits,
  species_polygons = spRanges,
  trait_column = "RBL",
  species_name_col = "sci_name",
  continent = FALSE,
  parallel = FALSE
)

# Run ecometric model
ecoModel <- ecometric_model(
  points_df = traitsByPoint$points,
  env_var = "precip",
  transform_fun = function(x) log(x + 1),
  inv_transform_fun = function(x) exp(x) - 1,
  min_species = 3
)

# Reconstruct environments for fossil sites
recon <- reconstruct_env(
  fossildata = fossils,
  model_out = ecoModel,
  match_nearest = TRUE,
  fossil_lon = "Long",
  fossil_lat = "Lat",
  modern_id = "ID",
  modern_lon = "Longitude",
  modern_lat = "Latitude"
)

# Plot the ecometric trait–environment space
ecometricPlot <- ecometric_space(
  model_out = ecoModel,
  env_name = "Precipitation (log mm)",
  fossil_data = recon
)

# Display plot
print(ecometricPlot)
}
}
