% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif_df.R
\name{vif_df}
\alias{vif_df}
\title{Variance Inflation Factor}
\usage{
vif_df(df = NULL, predictors = NULL, quiet = FALSE)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
data frame; predictors names their VIFs
}
\description{
Computes the Variance Inflation Factor of numeric variables in a data frame.

This function computes the VIF (see section \strong{Variance Inflation Factors} below) in two steps:
\itemize{
\item Applies \code{\link[base:solve]{base::solve()}} to obtain the precision matrix, which is the inverse of the covariance matrix between all variables in \code{predictors}.
\item Uses \code{\link[base:diag]{base::diag()}} to extract the diagonal of the precision matrix, which contains the variance of the prediction of each predictor from all other predictors, and represents the VIF.
}
}
\section{Variance Inflation Factors}{


The Variance Inflation Factor for a given variable \eqn{a} is computed as \eqn{1/(1-R2)}, where \eqn{R2} is the multiple R-squared of a multiple regression model fitted using \eqn{a} as response and all other predictors in the input data frame as predictors, as in  \eqn{a = b + c + ...}.

The square root of the VIF of \eqn{a} is the factor by which the confidence interval of the estimate for \eqn{a} in the linear model \eqn{y = a + b + c + ...}` is widened by multicollinearity in the model predictors.

The range of VIF values is (1, Inf]. The recommended thresholds for maximum VIF may vary depending on the source consulted, being the most common values, 2.5, 5, and 10.
}

\examples{

data(
  vi,
  vi_predictors_numeric
)

#subset to limit run time
df <- vi[1:1000, ]

#apply pairwise correlation first
selection <- cor_select(
  df = df,
  predictors = vi_predictors_numeric,
  quiet = TRUE
)

#VIF data frame
df <- vif_df(
  df = df,
  predictors = selection
)

df

}
\references{
\itemize{
\item David A. Belsley, D.A., Kuh, E., Welsch, R.E. (1980). Regression Diagnostics: Identifying Influential Data and Sources of Collinearity. John Wiley & Sons. DOI: 10.1002/0471725153.
}
}
\seealso{
Other vif: 
\code{\link{vif_select}()}
}
\concept{vif}
