% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{kidney}
\alias{kidney}
\title{Treatment of hypernephroma}
\format{
A data frame with 36 rows and 4 variables:
\describe{
\item{\code{nephrectomy}}{integer indicator for nephrectomy (0=No; 1=Yes)}
\item{\code{age}}{integer age group (1=<60; 2=60-70; 3=>70}
\item{\code{time}}{integer for the follow-up time in months}
\item{\code{status}}{integer for status at the end of follow-up (1=died; 0=censored)}
}
}
\usage{
kidney
}
\description{
This study was undertaken at the University of Oklahoma
Health Sciences Center to investigate survival among 36
patients with a kidney tumour (hypernephroma). Standard tangent
included chemotherapy and immunotherapy, with some patients
also having a nephrectomy, or surgical removal of the
kidney. For further details, see Lee and Wang (2013).
}
\references{
Lee ET, Wang J. Statistical Methods for Survival Data Analysis. New York, NY: John Wiley & Sons; 2013, fourth edition. \url{https://www.wiley.com/en-sg/Statistical+Methods+for+Survival+Data+Analysis\%252C+4th+Edition-p-9781118095027}
}
\keyword{datasets}
