% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{cmahalanobis}
\alias{cmahalanobis}
\title{Calculate the Mahalanobis distance for each species.}
\usage{
cmahalanobis(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Mahalanobis Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate the Mahalanobis distances matrix.}

\item{plot}{Logical, if TRUE, a plot of Mahalanobis distances matrix is displayed.}

\item{plot_title}{The title to be used for the plot if plot is TRUE.}
}
\value{
A matrix containing Mahalanobis distances between each pair of groups and the plot.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Mahalanobis distances about it.
}
\examples{
# Example with the iris dataset

data(iris)

# Calculate the Mahalanobis distance with the cmahalanobis function
cmahalanobis(iris, ~Species, plot = TRUE, plot_title = "Mahalanobis Distance Between Groups")

# Example with the mtcars dataset
data(mtcars)

# Calculate the Mahalanobis distance with the cmahalanobis function
cmahalanobis(mtcars, ~am, plot = TRUE, plot_title = "Mahalanobis Distance Between Groups")

}
