% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{ccbhattacharyya}
\alias{ccbhattacharyya}
\alias{cbhattacharyya}
\title{Calculate the Bhattacharyya distance for each species.}
\usage{
cbhattacharyya(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Bhattacharyya Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate the Bhattacharyya distances matrix.}

\item{plot}{Logical, if TRUE, a plot of Bhattacharyya distances matrix is displayed.}

\item{plot_title}{The title to be used for the plot if plot is TRUE.}
}
\value{
A matrix containing Bhattacharyya distances between each pair of groups and the plot.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Bhattacharyya distances about it.
}
\examples{
# Example with the iris dataset
cbhattacharyya(iris, ~Species, plot = TRUE, plot_title = "Bhattacharyya Distance Between Groups")

# Example with the mtcars dataset
cbhattacharyya(mtcars, ~am, plot = TRUE, plot_title = "Bhattacharyya Distance Between Groups")

}
