% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{G1}
\alias{G1}
\title{G1 score}
\usage{
G1(confusion)
}
\arguments{
\item{confusion}{Confusion matrix as obtained from \link{confusion}}
}
\value{
A numeric in [0,1].
}
\description{
Computes G1 score from a confusion matrix, see \link{confusion}. G1 score is F1 score with
reversed roles of 0/1 classifications, see Petersen et al. 2022.
The G1 score is defined as  \eqn{2 * TN/(2 * TN + FN + FP)}, where TN are true negatives,
FP are false positives, and FN are false negatives. If TN + FN + FP = 0, 1 is returned.
}
\references{
Petersen, Anne Helby, et al. "Causal discovery for observational sciences using
supervised machine learning." arXiv preprint arXiv:2202.12813 (2022).
}
