% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{barray}
\alias{barray}
\title{Convert 3d array of CATA data to 4d array of CATA differences}
\usage{
barray(X, values = "bc", type.in = "binary", type.out = "binary")
}
\arguments{
\item{X}{three-dimensional array (\eqn{I} assessors, \eqn{J}
products, \eqn{M} attributes) where values are \code{0} (not checked) 
or \code{1} (checked)}

\item{values}{\code{"bc"} (default) returns two outcomes: \code{b} and 
\code{c}; otherwise \code{"abcd"} returns four outcomes: \code{a}, \code{b}, 
\code{c}, \code{d}.}

\item{type.in}{type of data submitted; default (\code{binary}) may be set to
\code{ordinal} or \code{scale}.}

\item{type.out}{currently only \code{binary} is implemented}
}
\value{
A four-dimensional array of product comparisons having \eqn{I} 
assessors, \eqn{J(J-1)/2} product comparisons, outcomes (see \code{values}
parameter), \eqn{M} attributes
}
\description{
Converts a three-dimensional array (\eqn{I} assessors, \eqn{J}
products, \eqn{M} attributes) to a four-dimensional array of product
comparisons (\eqn{I} assessors, \eqn{J(J-1)/2}
product comparisons, two outcomes (of type \code{b} or \code{c}), \eqn{M} 
attributes)
}
\examples{
data(bread)

# Get the 4d array of CATA differences for the first 8 consumers
b <- barray(bread$cata[1:8,,])
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2022). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, 104564. 
\doi{10.1016/j.foodqual.2022.104564}.
}
\author{
J.C. Castura
}
