% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotPercentiles}
\alias{plotPercentiles}
\title{Plot norm curves against actual percentiles}
\usage{
plotPercentiles(
  model,
  minRaw = NULL,
  maxRaw = NULL,
  minAge = NULL,
  maxAge = NULL,
  raw = NULL,
  group = NULL,
  percentiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  scale = NULL,
  title = NULL,
  subtitle = NULL,
  points = F
)
}
\arguments{
\item{model}{The Taylor polynomial regression model object from the cNORM}

\item{minRaw}{Lower bound of the raw score (default = 0)}

\item{maxRaw}{Upper bound of the raw score}

\item{minAge}{Variable to restrict the lower bound of the plot to a specific age}

\item{maxAge}{Variable to restrict the upper bound of the plot to a specific age}

\item{raw}{The name of the raw variable}

\item{group}{The name of the grouping variable; the distinct groups are automatically
determined}

\item{percentiles}{Vector with percentile scores, ranging from 0 to 1 (exclusive)}

\item{scale}{The norm scale, either 'T', 'IQ', 'z', 'percentile' or
self defined with a double vector with the mean and standard deviation,
f. e. c(10, 3) for Wechsler scale index points; if NULL, scale information from the
data preparation is used (default)}

\item{title}{custom title for plot}

\item{subtitle}{custom title for plot}

\item{points}{Logical indicating whether to plot the data points. Default is TRUE.}
}
\description{
The function plots the norm curves based on the regression model against
the actual percentiles from the raw data. As in 'plotNormCurves',
please check for inconsistent curves, especially intersections.
Violations of this assumption are a strong
indication for problems
in modeling the relationship between raw and norm scores.
In general, extrapolation (point 1 and 2) can carefully be done to a
certain degree outside the original sample, but it should in general
be handled with caution.
The original percentiles are displayed as distinct points in the according
color, the model based projection of percentiles are drawn as lines.
Please note, that the estimation of the percentiles of the raw data is done with
the quantile function with the default settings.
In case, you get 'jagged' or disorganized percentile curve, try to reduce the 'k'
and/or 't' parameter in modeling.
}
\examples{
# Load example data set, compute model and plot results
result <- cnorm(raw = elfe$raw, group = elfe$group)
plotPercentiles(result)
}
\seealso{
plotNormCurves, plotPercentileSeries

Other plot: 
\code{\link{compare}()},
\code{\link{plot.cnorm}()},
\code{\link{plot.cnormBetaBinomial}()},
\code{\link{plot.cnormBetaBinomial2}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNorm}()},
\code{\link{plotNormCurves}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotRaw}()},
\code{\link{plotSubset}()}
}
\concept{plot}
