% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{getNormCurve}
\alias{getNormCurve}
\title{Computes the curve for a specific T value}
\usage{
getNormCurve(
  norm,
  model,
  minAge = NULL,
  maxAge = NULL,
  step = 0.1,
  minRaw = NULL,
  maxRaw = NULL
)
}
\arguments{
\item{norm}{The specific norm score, e. g. T value}

\item{model}{The model from the regression modeling obtained with the cnorm function}

\item{minAge}{Age to start from}

\item{maxAge}{Age to stop at}

\item{step}{Stepping parameter for the precision when retrieving of the values, lower
values indicate higher precision (default 0.1).}

\item{minRaw}{lower bound of the range of raw scores (default = 0)}

\item{maxRaw}{upper bound of raw scores}
}
\value{
data.frame of the variables raw, age and norm
}
\description{
As with this continuous norming regression approach, raw scores are modeled as a function of age and norm score
(location), getNormCurve is a straightforward approach to show the raw score development over
age, while keeping the norm value constant. This way, e. g. academic performance or intelligence development
of a specific ability is shown.
}
\examples{
# Generate cnorm object from example data
cnorm.elfe <- cnorm(raw = elfe$raw, group = elfe$group)
getNormCurve(35, cnorm.elfe)
}
\seealso{
Other predict: 
\code{\link{derivationTable}()},
\code{\link{normTable}()},
\code{\link{predict.cnormBetaBinomial}()},
\code{\link{predict.cnormBetaBinomial2}()},
\code{\link{predictNorm}()},
\code{\link{predictRaw}()},
\code{\link{rawTable}()}
}
\concept{predict}
