% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{axe-terms}
\alias{axe-terms}
\alias{axe_env.terms}
\title{Axing for terms inputs.}
\usage{
\method{axe_env}{terms}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed terms object.
}
\description{
Generics related to axing objects of the term class.
}
\examples{
\dontshow{if (rlang::is_installed("rpart")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Using lm
wrapped_lm <- function() {
  some_junk_in_environment <- runif(1e6)
  fit <- lm(mpg ~ ., data = mtcars)
  return(fit)
}

# Remove junk
cleaned_lm <- axe_env(wrapped_lm(), verbose = TRUE)

# Check size
lobstr::obj_size(cleaned_lm)

# Compare environment in terms component
lobstr::obj_size(attr(wrapped_lm()$terms, ".Environment"))
lobstr::obj_size(attr(cleaned_lm$terms, ".Environment"))

# Using rpart
library(rpart)

wrapped_rpart <- function() {
  some_junk_in_environment <- runif(1e6)
  fit <- rpart(Kyphosis ~ Age + Number + Start,
               data = kyphosis,
               x = TRUE,
               y = TRUE)
  return(fit)
}

lobstr::obj_size(wrapped_rpart())
lobstr::obj_size(axe_env(wrapped_rpart()))
\dontshow{\}) # examplesIf}
}
