% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_destatis.R
\name{destatis_data_cube}
\alias{destatis_data_cube}
\title{Retrieve Destatis cube data}
\usage{
destatis_data_cube(
  name,
  params = list(),
  username = "GAST",
  password = "GAST",
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{name}{Cube id.}

\item{params}{Query parameters.}

\item{username}{Genesis username (default "GAST").}

\item{password}{Genesis password (default "GAST").}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with cube data in a text column.
}
\description{
Retrieve Destatis cube data
}
\details{
Returns cube data as text (csv by default).
Official docs: https://github.com/bundesAPI/destatis-api.
}
\examples{
\dontrun{
destatis_data_cube("21231BJ001")
}

}
