% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_pegel_online.R
\name{pegel_online_timeseries}
\alias{pegel_online_timeseries}
\title{Get Pegel-Online timeseries metadata}
\usage{
pegel_online_timeseries(
  station,
  timeseries,
  params = list(),
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{station}{Station UUID, name, or number.}

\item{timeseries}{Timeseries shortname.}

\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with timeseries metadata.
}
\description{
Get Pegel-Online timeseries metadata
}
\details{
Returns metadata for a timeseries, including unit and gauge zero. Official
docs: https://pegel-online.api.bund.dev.
}
\examples{
\dontrun{
stations <- pegel_online_stations(params = list(limit = 1))
pegel_online_timeseries(stations$uuid[[1]], "W")
}

}
\seealso{
\code{\link[=pegel_online_measurements]{pegel_online_measurements()}} for measurement values.
}
