% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earning_fun.R
\name{earning_fun}
\alias{earning_fun}
\title{Finding optimal earning under kinked/notched budget set}
\usage{
earning_fun(n, elas, t1, t2, Tax, zstar)
}
\arguments{
\item{n}{Ability of person (earnings with zero tax)}

\item{elas}{elasticity of earnings w.r.t.  net-of-tax rate}

\item{t1}{Tax rate before notch/kink}

\item{t2}{Tax rate after notch/kink}

\item{Tax}{height of notch (zero for pure kink)}

\item{zstar}{place of notch/kink (critical earning point)}
}
\value{
Optimal earning level.
}
\description{
For an agent with quasi-linear iso-elastic utility, find the utility
maximizing earning level.
}
\details{
\code{earn_funciton} is intended to simulate earnings of agents
under a kink or notch.
}
\examples{
earning_fun(1200,0.2,0.1,0.3,100,1000)

}
\seealso{
\code{\link{util_calc}}, \code{\link{bunch}}
}

