% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_cor}
\alias{pair_cor}
\title{Pearson, Spearman or Kendall correlation}
\usage{
pair_cor(d, method = "pearson", handle.na = TRUE, warnings = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{method}{A character string for the correlation coefficient to be calculated. Either "pearson" (default),
"spearman", or "kendall". If the value is "all", then all three correlations are calculated.}

\item{handle.na}{If TRUE uses pairwise complete observations to calculate correlation coefficient, otherwise NAs not handled.}

\item{warnings}{If TRUE, generates a warning for datasets of one row, one column, or with constant variables.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with calculated association value for every numeric variable pair,
or NULL if there are not at least two numeric variables
}
\description{
Calculates one of either pearson, spearman or kendall correlation for every numeric variable pair in a dataset.
}
\examples{
pair_cor(iris)
pair_cor(iris, method="kendall")
pair_cor(iris, method="spearman")
pair_cor(iris, method="all")
}
\seealso{
See \code{\link{pair_methods}}  for other score options.
}
