% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pairwise_by}
\alias{pairwise_by}
\title{Constructs a pairwise result for each level of a by variable.}
\usage{
pairwise_by(
  d,
  by,
  pair_fun,
  ungrouped = TRUE,
  warnings = TRUE,
  add.nobs = FALSE
)
}
\arguments{
\item{d}{a dataframe}

\item{by}{a character string for the name of the conditioning variable.}

\item{pair_fun}{A function returning a \code{pairwise} from a dataset.}

\item{ungrouped}{If TRUE calculates the ungrouped score in addition to grouped scores.}

\item{warnings}{If TRUE, generates a warning for datasets of one row, one column, or with constant variables.}

\item{add.nobs}{If TRUE, adds an extra column containing the number of observations used for each score.}
}
\value{
tibble of class "pairwise"
}
\description{
Constructs a pairwise result for each level of a by variable.
}
\examples{
pairwise_by(iris, by="Species", pair_cor)


}
