% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_dim2flat.R
\name{cast_dim2flat}
\alias{cast_dim2flat}
\alias{cast_dim2flat.default}
\title{Cast Dimensional List into a Flattened List}
\usage{
cast_dim2flat(x, ...)

\method{cast_dim2flat}{default}(x, ...)
}
\arguments{
\item{x}{a list}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
A flattened list,
with names that indicate the original dimensional positions of the elements. \cr
\cr
}
\description{
\code{cast_dim2flat()} casts a dimensional list
(i.e. recursive array)
into a flat list
(i.e. recursive vector),
but with names that indicate the original dimensional positions of the elements. \cr
\cr
Primary purpose for this function
is to facilitate printing or summarizing dimensional lists. \cr
\cr
}
\examples{

x <- array(
  sample(list(letters, month.name, 1:10 ~ "foo"), prod(4:2), TRUE),
  dim = 4:2,
  dimnames = list(NULL, LETTERS[1:3], c("x", "y"))
)


# summarizing ====
summary(x) # dimensional information is lost

# In the following instances, dimensional position info is retained:
cast_dim2flat(x) |> summary()

cast_dim2flat(x[1:3, 1:2, 2, drop = FALSE]) |> summary()

cast_dim2flat(x[1:3, 1:2, 2, drop = TRUE]) |> summary()


# printing ====
print(x) # too compact
cast_dim2flat(x) |> print() # much less compact


}
\seealso{
\link{broadcast_casting} \cr
}
