% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_hier2dim.R
\name{cast_hier2dim}
\alias{cast_hier2dim}
\alias{hier2dim}
\alias{cast_hier2dim.default}
\alias{hier2dim.default}
\title{Cast Hierarchical List into Dimensional list}
\usage{
cast_hier2dim(x, ...)

hier2dim(x, ...)

\method{cast_hier2dim}{default}(
  x,
  in2out = TRUE,
  maxdepth = 16L,
  recurse_classed = FALSE,
  padding = list(NULL),
  ...
)

\method{hier2dim}{default}(x, in2out = TRUE, maxdepth = 16L, recurse_classed = FALSE, ...)
}
\arguments{
\item{x}{a nested list. \cr
If \code{x} has redundant nesting,
it is advisable (though not necessary) to reduce the redundant nesting using \link{dropnests}.}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{in2out}{see \link{broadcast_casting}.}

\item{maxdepth}{a single, positive integer,
giving the maximum depth to recurse into the list. \cr
The surface-level elements of a list is depth 1. \cr}

\item{recurse_classed}{\code{TRUE} or \code{FALSE},
indicating if the function should also recurse through classed lists within \code{x},
like data.frames.}

\item{padding}{a list of length \code{1},
giving the padding value to use when padding is required. \cr
Padding is used to ensure every all slices of the same dimension in the output
have equal number of elements
(for example, all rows must have the same number of columns).}
}
\value{
For \code{hier2dim()}: \cr
An integer vector,
giving the dimensions \code{x} would have,
if casted by \code{cast_hier2dim()}. \cr
The names of the output indicates if padding is required (name "padding"),
or no padding is required (no name) for that dimension; \cr
Padding will be required if not all list-elements at a certain depth have the same length. \cr
\cr
For \code{cast_hier2dim()}: \cr
An array of type \code{list}, with the dimensions given by \code{hier2dim()}. \cr
If the output needs padding (indicated by \code{hier2dim()}),
the output will have more elements than \code{x},
filled with a padding value (as specified in the \code{padding} argument). \cr
\cr
}
\description{
\code{cast_hier2dim()} casts a hierarchical/nested list into a dimensional list
(i.e. an array of type \code{list}). \cr
\code{hier2dim()} takes a hierarchical/nested list,
and predicts what dimensions the list would have,
if casted by the \code{cast_hier2dim()} function. \cr
\cr
}
\examples{


# Example 1: Basics ====
x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)

# predict what dimensions `x` would have if casted as dimensional:
hier2dim(x)

x2 <- cast_hier2dim(x) # cast as dimensional

# since the original list uses the same names for all elements within the same depth,
# dimnames can be set easily:
dimnames(x2) <- list( # go from deep names to surface names
  c("height", "weight", "sex"),
  c("class1", "class2"),
  c("group1", "group2")
)

print(x2) # very compact, maybe too compact...?

# print a small portion of the list, but less compact:
cast_dim2flat(x2[, 1:2, "group1", drop = FALSE])


# Example 2: Cast from outside to inside ====
x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)

# by default, `in2out = TRUE`;
# for this example, `in2out = FALSE` is used

# predict what dimensions `x` would have if casted as dimensional:
hier2dim(x, in2out = FALSE)

x2 <- cast_hier2dim(x, in2out = FALSE) # cast as dimensional

# since the original list uses the same names for all elements within the same depth,
# dimnames can be set easily:
# because in2out = FALSE, go from the shallow names to the deeper names:
dimnames(x2) <- list( # notice the order here is reversed, because in2out = FALSE
  c("group1", "group2"),
  c("class1", "class2"),
  c("height", "weight", "sex")
)

print(x2) # very compact, maybe too compact...?

# print a small portion of the list, but less compact:
cast_dim2flat(x2["group1", 1:2, , drop = FALSE])



# Example 3: padding ====

# For Example 3, take the same list as before, but remove x$group1$class2:

x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)


hier2dim(x) # as indicated here, dimension 2 (i.e. columns) will have padding

# casting this to a dimensional list will resulting in padding with `NULL`:
x2 <- cast_hier2dim(x)
print(x2)
# The `NULL` values are added for padding.
# This is because all slices of the same dimension need to have the same number of elements.  
# For example, all rows need to have the same number of columns.

# one can also use custom padding:
x2 <- cast_hier2dim(x, padding = list(~ "this is padding"))
print(x2)

dimnames(x2) <- list(
  c("height", "weight", "sex"),
  c("class1", "class2"),
  c("group1", "group2")
)

print(x2)

cast_dim2flat(x2[1:2, , , drop = FALSE])

# we can also use in2out = FALSE:
x2 <- cast_hier2dim(x, in2out = FALSE, padding = list(~ "this is padding"))
dimnames(x2) <- list( # notice the order here is reversed, because in2out = FALSE
  c("group1", "group2"),
  c("class1", "class2"),
  c("height", "weight", "sex")
  
)
print(x2)

cast_dim2flat(x2[, , 1:2, drop = FALSE])

}
\seealso{
\link{broadcast_casting} \cr
}
