% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate_statistics.R
\name{bivariate_statistics}
\alias{bivariate_statistics}
\alias{covariance}
\alias{means_and_covariance}
\alias{correlation_coefficient}
\title{Bivariate Statistics Functions}
\usage{
covariance(x, y)

means_and_covariance(x, y)

correlation_coefficient(x, y)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector.}
}
\value{
A numeric value or vector with the computed statistic.
}
\description{
Functions to compute various bivariate statistics.
}
\examples{
# Covariance
covariance(c(1, 2, 3), c(4, 5, 6))
# Means and Covariance
means_and_covariance(c(1, 2, 3), c(4, 5, 6))
# Correlation Coefficient
correlation_coefficient(c(1, 2, 3), c(4, 5, 6))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/bivariate_statistics.html}{Boost Documentation} for more details on the mathematical background.
}
