% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-misc.R
\name{rand_names}
\alias{rand_names}
\title{Random IDs}
\usage{
rand_names(
  old_names = character(0L),
  n = 1L,
  length = 15L,
  chars = letters,
  prefix = "",
  suffix = ""
)
}
\arguments{
\item{old_names}{Disallowed IDs}

\item{n}{Number of IDs to generate}

\item{length}{ID length}

\item{chars}{Allowed characters}

\item{prefix, suffix}{ID pre-/suffix}
}
\value{
A character vector of length \code{n} where each entry contains \code{length}
characters (all among \code{chars} and start/end with \code{prefix}/\code{suffix}), is
guaranteed to be unique and not present among values passed as \code{old_names}.
}
\description{
Randomly generated unique IDs are used throughout the package, created by
\code{rand_names()}. If random strings are required that may not clash with a set
of existing values, this can be guaranteed by passing them as \code{old_names}.
The set of allowed characters can be controlled via \code{chars} and non-random
pre- and suffixes may be specified as \code{prefix}/\code{suffix} arguments, while
uniqueness is guaranteed including pre- and suffixes.
}
\examples{
rand_names(chars = c(letters, LETTERS, 0:9))
rand_names(length = 5L)
rand_names(n = 5L, prefix = "pre-", suffix = "-suf")

}
