% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitIsoGrowth_class.R
\name{FitIsoGrowth}
\alias{FitIsoGrowth}
\alias{print.FitIsoGrowth}
\alias{plot.FitIsoGrowth}
\alias{summary.FitIsoGrowth}
\alias{residuals.FitIsoGrowth}
\alias{coef.FitIsoGrowth}
\alias{vcov.FitIsoGrowth}
\alias{deviance.FitIsoGrowth}
\alias{fitted.FitIsoGrowth}
\alias{predict.FitIsoGrowth}
\alias{logLik.FitIsoGrowth}
\alias{AIC.FitIsoGrowth}
\title{FitIsoGrowth class}
\usage{
\method{print}{FitIsoGrowth}(x, ...)

\method{plot}{FitIsoGrowth}(
  x,
  y = NULL,
  ...,
  line_col = "black",
  line_size = 1,
  line_type = 1,
  point_col = "black",
  point_size = 3,
  point_shape = 16
)

\method{summary}{FitIsoGrowth}(object, ...)

\method{residuals}{FitIsoGrowth}(object, ...)

\method{coef}{FitIsoGrowth}(object, ...)

\method{vcov}{FitIsoGrowth}(object, ...)

\method{deviance}{FitIsoGrowth}(object, ...)

\method{fitted}{FitIsoGrowth}(object, ...)

\method{predict}{FitIsoGrowth}(object, times = NULL, ...)

\method{logLik}{FitIsoGrowth}(object, ...)

\method{AIC}{FitIsoGrowth}(object, ..., k = 2)
}
\arguments{
\item{x}{The object of class \code{FitIsoGrowth} to plot.}

\item{...}{ignored}

\item{y}{ignored}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}}

\item{point_col}{Aesthetic parameter to change the colour of the point geom, see: \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}}

\item{point_size}{Aesthetic parameter to change the size of the point geom, see: \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}}

\item{point_shape}{Aesthetic parameter to change the shape of the point geom, see: \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}}

\item{object}{an instance of FitIsoGrowth}

\item{times}{numeric vector describing the time points for the prediction.
If \code{NULL} (default), uses the same points as those used for fitting.}

\item{k}{penalty for the parameters (k=2 by default)}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

The class \link{FitIsoGrowth} has been superseded by the top-level
class \link{GrowthFit}, which provides a unified approach for growth modelling.

Still, it is still returned if the superseded \code{\link[=fit_isothermal_growth]{fit_isothermal_growth()}} is called.

It is a subclass of list with the items:
\itemize{
\item data: data used for model fitting
\item model: name of the primary inactivation model
\item starting_point: initial value of the model parameters
\item known: fixed model parameters
\item fit: object returned by \code{\link[FME:modFit]{FME::modFit()}}
\item best_prediction: model prediction for the model fitted.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(FitIsoGrowth)}: print of the model

\item \code{plot(FitIsoGrowth)}: compares the fitted model against the data.

\item \code{summary(FitIsoGrowth)}: statistical summary of the fit.

\item \code{residuals(FitIsoGrowth)}: vector of model residuals.

\item \code{coef(FitIsoGrowth)}: vector of fitted model parameters.

\item \code{vcov(FitIsoGrowth)}: variance-covariance matrix of the model, estimated
as 1/(0.5*Hessian)

\item \code{deviance(FitIsoGrowth)}: deviance of the model.

\item \code{fitted(FitIsoGrowth)}: vector of fitted values.

\item \code{predict(FitIsoGrowth)}: vector of model predictions.

\item \code{logLik(FitIsoGrowth)}: loglikelihood of the model

\item \code{AIC(FitIsoGrowth)}: Akaike Information Criterion

}}
