context("create")

test_that("create_env()", {
  env <- create_env(lapply(letters, as.name), toupper)
  expect_equal(env$a, "A")
  expect_equal(env$x, "X")
  expect_null(env$X)
  expect_equal(length(ls(env)), length(letters))
  expect_error(env$a <- "a", "read-only")
})

test_that("create_env() with character", {
  env <- create_env(letters, toupper)
  expect_equal(env$a, "A")
  expect_equal(env$x, "X")
  expect_null(env$X)
  expect_equal(length(ls(env)), length(letters))
  expect_error(env$a <- "a", "read-only")
})

test_that("create_env() with inheritance", {
  env <- create_env(lapply(letters, as.name), toupper)
  env2 <- create_env(lapply(LETTERS, as.name), tolower, .enclos = env)
  expect_equal(get("a", env2), "A")
  expect_equal(get("x", env2), "X")
  expect_null(env2$a)
  expect_null(env2$x)
  expect_equal(env2$B, "b")
  expect_equal(env2$Y, "y")
  expect_equal(length(ls(env2)), length(letters))
  expect_error(env2$B <- "B", "read-only")
  expect_error(env2$a <- "a", NA)
  expect_equal(get("a", env2), "a")
})

test_that("create_env() with local function", {
  a <- function(x) b(x)
  b <- function(x) c(x)
  c <- function(x) toupper(x)
  env <- create_env(lapply(letters, as.name), a)
  expect_equal(env$a, "A")
  expect_equal(env$x, "X")
  expect_null(env$X)
  expect_equal(length(ls(env)), length(letters))
  expect_error(env$a <- "a", "read-only")
})
