% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{collect.tbl_BigQueryConnection}
\alias{collect.tbl_BigQueryConnection}
\title{Collect a BigQuery table}
\usage{
collect.tbl_BigQueryConnection(
  x,
  ...,
  n = Inf,
  api = c("json", "arrow"),
  page_size = NULL,
  max_connections = 6L
)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for more
details.}

\item{...}{Other arguments passed on to
\code{bq_project_query()}/\code{bq_project_query()}}

\item{n}{Maximum number of results to retrieve.
The default, \code{Inf}, will retrieve all rows.}

\item{api}{Which API to use? The \code{"json"} API works where ever bigrquery
does, but is slow and can require fiddling with the \code{page_size} parameter.
The \code{"arrow"} API is faster and more reliable, but only works if you
have also installed the bigrquerystorage package.

Because the \code{"arrow"} API is so much faster, it will be used automatically
if the bigrquerystorage package is installed.}

\item{page_size}{(JSON only) The number of rows requested per chunk. It is
recommended to leave this unspecified until you have evidence that the
\code{page_size} selected automatically by \code{bq_table_download()} is problematic.

When \code{page_size = NULL} bigrquery determines a conservative, natural chunk
size empirically. If you specify the \code{page_size}, it is important that each
chunk fits on one page, i.e. that the requested row limit is low enough to
prevent the API from paginating based on response size.}

\item{max_connections}{(JSON only) Number of maximum simultaneous
connections to BigQuery servers.}
}
\description{
This collect method is specialised for BigQuery tables, generating the
SQL from your dplyr commands, then calling \code{\link[=bq_project_query]{bq_project_query()}}
or \code{\link[=bq_dataset_query]{bq_dataset_query()}} to run the query, then \code{\link[=bq_table_download]{bq_table_download()}}
to download the results. Thus the arguments are a combination of the
arguments to \code{\link[dplyr:compute]{dplyr::collect()}}, \code{bq_project_query()}/\code{bq_dataset_query()},
and \code{bq_table_download()}.
}
