% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-query.R
\name{bq_query}
\alias{bq_query}
\alias{bq_project_query}
\alias{bq_dataset_query}
\title{Submit query to BigQuery}
\usage{
bq_project_query(x, query, destination_table = NULL, ..., quiet = NA)

bq_dataset_query(
  x,
  query,
  destination_table = NULL,
  ...,
  billing = NULL,
  quiet = NA
)
}
\arguments{
\item{x}{Either a project (a string) or a \link{bq_dataset}.}

\item{query}{SQL query string.}

\item{destination_table}{A \link{bq_table} where results should be stored.
If not supplied, results will be saved to a temporary table that lives
in a special dataset. You must supply this parameter for large
queries (> 128 MB compressed).}

\item{...}{Passed on to \code{\link[=bq_perform_query]{bq_perform_query()}}}

\item{quiet}{If \code{FALSE}, displays progress bar; if \code{TRUE} is silent;
if \code{NA} picks based on whether or not you're in an interactive context.}

\item{billing}{If you query a dataset that you only have read access
for, such as a public dataset, you must also submit a \code{billing} project.}
}
\value{
A \link{bq_table}
}
\description{
These submit a query (using \code{\link[=bq_perform_query]{bq_perform_query()}}) and then wait for it
complete (with \code{\link[=bq_job_wait]{bq_job_wait()}}). All BigQuery queries save their results
into a table (temporary or otherwise), so these functions return a \link{bq_table}
which you can then query for more information.
}
\examples{
\dontshow{if (bq_testable()) withAutoprint(\{ # examplesIf}
# Querying a project requires full name in query
tb <- bq_project_query(
  bq_test_project(),
  "SELECT count(*) FROM publicdata.samples.natality"
)
bq_table_fields(tb)
bq_table_download(tb)

# Querying a dataset sets default dataset so you can use bare table name,
# but for public data, you'll need to set a project to bill.
ds <- bq_dataset("publicdata", "samples")
tb <- bq_dataset_query(ds,
  query = "SELECT count(*) FROM natality",
  billing = bq_test_project()
)
bq_table_download(tb)

tb <- bq_dataset_query(ds,
  query = "SELECT count(*) FROM natality WHERE state = @state",
  parameters = list(state = "KS"),
  billing = bq_test_project()
)
bq_table_download(tb)
\dontshow{\}) # examplesIf}
}
