% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-auth.R
\name{bq_auth}
\alias{bq_auth}
\title{Authorize bigrquery}
\usage{
bq_auth(
  email = gargle::gargle_oauth_email(),
  path = NULL,
  scopes = c("https://www.googleapis.com/auth/bigquery",
    "https://www.googleapis.com/auth/cloud-platform"),
  cache = gargle::gargle_oauth_cache(),
  use_oob = gargle::gargle_oob_default(),
  token = NULL
)
}
\arguments{
\item{email}{Optional. If specified, \code{email} can take several different
forms:
\itemize{
\item \code{"jane@gmail.com"}, i.e. an actual email address. This allows the user to
target a specific Google identity. If specified, this is used for token
lookup, i.e. to determine if a suitable token is already available in the
cache. If no such token is found, \code{email} is used to pre-select the targeted
Google identity in the OAuth chooser. (Note, however, that the email
associated with a token when it's cached is always determined from the token
itself, never from this argument).
\item \code{"*@example.com"}, i.e. a domain-only glob pattern. This can be helpful if
you need code that "just works" for both \code{alice@example.com} and
\code{bob@example.com}.
\item \code{TRUE} means that you are approving email auto-discovery. If exactly one
matching token is found in the cache, it will be used.
\item \code{FALSE} or \code{NA} mean that you want to ignore the token cache and force a
new OAuth dance in the browser.
}

Defaults to the option named \code{"gargle_oauth_email"}, retrieved by
\code{\link[gargle:gargle_oauth_email]{gargle_oauth_email()}} (unless a wrapper package implements different
default behavior).}

\item{path}{JSON identifying the service account, in one of the forms
supported for the \code{txt} argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a
file path or JSON string).}

\item{scopes}{A character vector of scopes to request.
Pick from those listed at \url{https://developers.google.com/identity/protocols/oauth2/scopes}.}

\item{cache}{Specifies the OAuth token cache. Defaults to the option named
\code{"gargle_oauth_cache"}, retrieved via \code{\link[gargle:gargle_oauth_cache]{gargle_oauth_cache()}}.}

\item{use_oob}{Whether to use out-of-band authentication (or, perhaps, a
variant implemented by gargle and known as "pseudo-OOB") when first
acquiring the token. Defaults to the value returned by
\code{\link[gargle:gargle_oob_default]{gargle_oob_default()}}. Note that (pseudo-)OOB auth only affects
the initial OAuth dance. If we retrieve (and possibly refresh) a
cached token, \code{use_oob} has no effect.

If the OAuth client is provided implicitly by a wrapper package, its type
probably defaults to the value returned by
\code{\link[gargle:gargle_oauth_client_type]{gargle_oauth_client_type()}}. You can take control of the client
type by setting \code{options(gargle_oauth_client_type = "web")} or
\code{options(gargle_oauth_client_type = "installed")}.}

\item{token}{A token with class \link[httr:Token-class]{Token2.0} or an object of
httr's class \code{request}, i.e. a token that has been prepared with
\code{\link[httr:config]{httr::config()}} and has a \link[httr:Token-class]{Token2.0} in the
\code{auth_token} component.}
}
\description{
Authorize bigrquery to view and manage your BigQuery projects. This function is a
wrapper around \code{\link[gargle:token_fetch]{gargle::token_fetch()}}.

By default, you are directed to a web browser, asked to sign in to your
Google account, and to grant bigrquery permission to operate on your
behalf with Google BigQuery. By default, with your permission, these user
credentials are cached in a folder below your home directory, from where
they can be automatically refreshed, as necessary. Storage at the user
level means the same token can be used across multiple projects and
tokens are less likely to be synced to the cloud by accident.
}
\details{
Most users, most of the time, do not need to call \code{bq_auth()}
explicitly -- it is triggered by the first action that requires
authorization. Even when called, the default arguments often suffice.

However, when necessary, \code{bq_auth()} allows the user to explicitly:
\itemize{
\item Declare which Google identity to use, via an \code{email} specification.
\item Use a service account token or workload identity federation via
\code{path}.
\item Bring your own \code{token}.
\item Customize \code{scopes}.
\item Use a non-default \code{cache} folder or turn caching off.
\item Explicitly request out-of-band (OOB) auth via \code{use_oob}.
}

If you are interacting with R within a browser (applies to RStudio
Server, Posit Workbench, Posit Cloud, and Google Colaboratory), you need
OOB auth or the pseudo-OOB variant. If this does not happen
automatically, you can request it explicitly with \code{use_oob = TRUE} or,
more persistently, by setting an option via
\code{options(gargle_oob_default = TRUE)}.

The choice between conventional OOB or pseudo-OOB auth is determined
by the type of OAuth client. If the client is of the "installed" type,
\code{use_oob = TRUE} results in conventional OOB auth. If the client is of
the "web" type, \code{use_oob = TRUE} results in pseudo-OOB auth. Packages
that provide a built-in OAuth client can usually detect which type of
client to use. But if you need to set this explicitly, use the
\code{"gargle_oauth_client_type"} option:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(gargle_oauth_client_type = "web")       # pseudo-OOB
# or, alternatively
options(gargle_oauth_client_type = "installed") # conventional OOB
}\if{html}{\out{</div>}}

For details on the many ways to find a token, see
\code{\link[gargle:token_fetch]{gargle::token_fetch()}}. For deeper control over auth, use
\code{\link[=bq_auth_configure]{bq_auth_configure()}} to bring your own OAuth client or API key.
To learn more about gargle options, see \link[gargle:gargle_options]{gargle::gargle_options}.
}
\examples{
\dontrun{
## load/refresh existing credentials, if available
## otherwise, go to browser for authentication and authorization
bq_auth()

## force use of a token associated with a specific email
bq_auth(email = "jenny@example.com")

## force a menu where you can choose from existing tokens or
## choose to get a new one
bq_auth(email = NA)

## use a 'read only' scope, so it's impossible to change data
bq_auth(
  scopes = "https://www.googleapis.com/auth/devstorage.read_only"
)

## use a service account token
bq_auth(path = "foofy-83ee9e7c9c48.json")
}

}
\seealso{
Other auth functions: 
\code{\link{bq_auth_configure}()},
\code{\link{bq_deauth}()}
}
\concept{auth functions}
