% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bid_interpret.R
\name{bid_interpret}
\alias{bid_interpret}
\title{Document User Interpretation Stage in BID Framework}
\usage{
bid_interpret(
  previous_stage,
  central_question = NULL,
  data_story = NULL,
  user_personas = NULL
)
}
\arguments{
\item{previous_stage}{A tibble or list output from an earlier BID stage
function.}

\item{central_question}{A character string representing the main question to
be answered. If NULL, will be suggested based on previous stage
information.}

\item{data_story}{A list containing elements such as \code{hook},
\code{context}, \code{tension}, \code{resolution}, and optionally
\code{audience}, \code{metrics}, and \code{visual_approach}. If NULL,
elements will be suggested based on previous stage.}

\item{user_personas}{Optional list of user personas to consider in the
design.}
}
\value{
A tibble containing the documented information for the "Interpret"
stage.
}
\description{
This function documents the interpretation of user needs, capturing the
central question and the data storytelling narrative. It represents stage 2
in the BID framework.
}
\examples{
notice <- bid_notice(
  problem = "Users struggle with complex data",
  evidence = "Test results indicate delays"
)

# Basic usage
bid_interpret(
  previous_stage = notice,
  central_question = "What drives the decline in user engagement?",
  data_story = list(
    hook = "Declining trend in engagement",
    context = "Previous high engagement levels",
    tension = "Unexpected drop",
    resolution = "Investigate new UI changes",
    audience = "Marketing team",
    metrics = c("Daily Active Users", "Session Duration"),
    visual_approach = "Comparison charts showing before/after UI change"
  )
)

# Let the function suggest content based on previous stage
bid_interpret(
  previous_stage = notice
)

# With user personas
bid_interpret(
  previous_stage = notice,
  central_question = "How can we improve data discovery?",
  data_story = list(
    hook = "Users are missing key insights",
    context = "Critical data is available but overlooked",
    tension = "Time-sensitive decisions are delayed",
    resolution = "Highlight key metrics more effectively"
  ),
  user_personas = list(
    list(
      name = "Sara, Data Analyst",
      goals = "Needs to quickly find patterns in data",
      pain_points = "Gets overwhelmed by too many visualizations",
      technical_level = "Advanced"
    ),
    list(
      name = "Marcus, Executive",
      goals = "Wants high-level insights at a glance",
      pain_points = "Limited time to analyze detailed reports",
      technical_level = "Basic"
    )
  )
)

}
