% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgmCompare.R
\name{bgmCompare}
\alias{bgmCompare}
\title{Bayesian Estimation and Variable Selection for Group Differences in Markov Random Fields}
\usage{
bgmCompare(
  x,
  y,
  group_indicator,
  difference_selection = TRUE,
  variable_type = "ordinal",
  baseline_category,
  difference_scale = 1,
  difference_prior = c("Bernoulli", "Beta-Bernoulli"),
  difference_probability = 0.5,
  beta_bernoulli_alpha = 1,
  beta_bernoulli_beta = 1,
  pairwise_scale = 2.5,
  main_alpha = 0.5,
  main_beta = 0.5,
  iter = 1000,
  warmup = 1000,
  na_action = c("listwise", "impute"),
  update_method = c("nuts", "adaptive-metropolis", "hamiltonian-mc"),
  target_accept,
  hmc_num_leapfrogs = 100,
  nuts_max_depth = 10,
  learn_mass_matrix = FALSE,
  chains = 4,
  cores = parallel::detectCores(),
  display_progress = c("per-chain", "total", "none"),
  seed = NULL,
  main_difference_model,
  reference_category,
  main_difference_scale,
  pairwise_difference_scale,
  pairwise_difference_prior,
  main_difference_prior,
  pairwise_difference_probability,
  main_difference_probability,
  pairwise_beta_bernoulli_alpha,
  pairwise_beta_bernoulli_beta,
  main_beta_bernoulli_alpha,
  main_beta_bernoulli_beta,
  interaction_scale,
  threshold_alpha,
  threshold_beta,
  burnin,
  save
)
}
\arguments{
\item{x}{A data frame or matrix of binary and ordinal responses for
Group 1. Variables should be coded as nonnegative integers starting at
0. For ordinal variables, unused categories are collapsed; for
Blume–Capel variables, all categories are retained.}

\item{y}{Optional data frame or matrix for Group 2 (two-group designs).
Must have the same variables (columns) as \code{x}.}

\item{group_indicator}{Optional integer vector of group memberships for
rows of \code{x} (multi-group designs). Ignored if \code{y} is supplied.}

\item{difference_selection}{Logical. If \code{TRUE}, spike-and-slab priors
are applied to difference parameters. Default: \code{TRUE}.}

\item{variable_type}{Character vector specifying type of each variable:
\code{"ordinal"} (default) or \code{"blume-capel"}.}

\item{baseline_category}{Integer or vector giving the baseline category
for Blume–Capel variables.}

\item{difference_scale}{Double. Scale of the Cauchy prior for difference
parameters. Default: \code{1}.}

\item{difference_prior}{Character. Prior for difference inclusion:
\code{"Bernoulli"} or \code{"Beta-Bernoulli"}. Default: \code{"Bernoulli"}.}

\item{difference_probability}{Numeric. Prior inclusion probability for
differences (Bernoulli prior). Default: \code{0.5}.}

\item{beta_bernoulli_alpha, beta_bernoulli_beta}{Doubles. Shape parameters
of the Beta prior for inclusion probabilities in the Beta–Bernoulli
model. Defaults: \code{1}.}

\item{pairwise_scale}{Double. Scale of the Cauchy prior for baseline
pairwise interactions. Default: \code{2.5}.}

\item{main_alpha, main_beta}{Doubles. Shape parameters of the beta-prime
prior for baseline threshold parameters. Defaults: \code{0.5}.}

\item{iter}{Integer. Number of post–warmup iterations per chain.
Default: \code{1e3}.}

\item{warmup}{Integer. Number of warmup iterations before sampling.
Default: \code{1e3}.}

\item{na_action}{Character. How to handle missing data:
\code{"listwise"} (drop rows) or \code{"impute"} (impute within Gibbs).
Default: \code{"listwise"}.}

\item{update_method}{Character. Sampling algorithm:
\code{"adaptive-metropolis"}, \code{"hamiltonian-mc"}, or \code{"nuts"}.
Default: \code{"nuts"}.}

\item{target_accept}{Numeric between 0 and 1. Target acceptance rate.
Defaults: 0.44 (Metropolis), 0.65 (HMC), 0.60 (NUTS).}

\item{hmc_num_leapfrogs}{Integer. Leapfrog steps for HMC. Default: \code{100}.}

\item{nuts_max_depth}{Integer. Maximum tree depth for NUTS. Default: \code{10}.}

\item{learn_mass_matrix}{Logical. If \code{TRUE}, adapt the mass matrix
during warmup (HMC/NUTS only). Default: \code{FALSE}.}

\item{chains}{Integer. Number of parallel chains. Default: \code{4}.}

\item{cores}{Integer. Number of CPU cores. Default:
\code{parallel::detectCores()}.}

\item{display_progress}{Character. Controls progress reporting:
\code{"per-chain"}, \code{"total"}, or \code{"none"}.
Default: \code{"per-chain"}.}

\item{seed}{Optional integer. Random seed for reproducibility.}

\item{main_difference_model, reference_category, pairwise_difference_scale, main_difference_scale, pairwise_difference_prior, main_difference_prior, pairwise_difference_probability, main_difference_probability, pairwise_beta_bernoulli_alpha, pairwise_beta_bernoulli_beta, main_beta_bernoulli_alpha, main_beta_bernoulli_beta, interaction_scale, threshold_alpha, threshold_beta, burnin, save}{`r lifecycle::badge("deprecated")`
Deprecated arguments as of **bgms 0.1.6.0**.
Use `difference_scale`, `difference_prior`, `difference_probability`,
`beta_bernoulli_alpha`, `beta_bernoulli_beta`, `baseline_category`,
`pairwise_scale`, and `warmup` instead.}
}
\value{
A list of class \code{"bgmCompare"} containing posterior summaries,
posterior mean matrices, and raw MCMC samples:
\itemize{
  \item \code{posterior_summary_main_baseline},
    \code{posterior_summary_pairwise_baseline}: summaries of baseline
    thresholds and pairwise interactions.
  \item \code{posterior_summary_main_differences},
    \code{posterior_summary_pairwise_differences}: summaries of group
    differences in thresholds and pairwise interactions.
  \item \code{posterior_summary_indicator}: summaries of inclusion
    indicators (if \code{difference_selection = TRUE}).
  \item \code{posterior_mean_main_baseline},
    \code{posterior_mean_pairwise_baseline}: posterior mean matrices
    (legacy style).
  \item \code{raw_samples}: list of raw draws per chain for main,
    pairwise, and indicator parameters.
  \item \code{arguments}: list of function call arguments and metadata.
}

The \code{summary()} method prints formatted summaries, and
\code{coef()} extracts posterior means.

NUTS diagnostics (tree depth, divergences, energy, E-BFMI) are included
in \code{fit$nuts_diag} if \code{update_method = "nuts"}.
}
\description{
The \code{bgmCompare} function estimates group differences in category
threshold parameters (main effects) and pairwise interactions (pairwise
effects) of a Markov Random Field (MRF) for binary and ordinal variables.
Groups can be defined either by supplying two separate datasets (\code{x} and
\code{y}) or by a group membership vector. Optionally, Bayesian variable
selection can be applied to identify differences across groups.
}
\details{
This function extends the ordinal MRF framework
\insertCite{MarsmanVandenBerghHaslbeck_2024;textual}{bgms} to multiple
groups. The basic idea of modeling, analyzing, and testing group
differences in MRFs was introduced in
\insertCite{MarsmanWaldorpSekulovskiHaslbeck_2024;textual}{bgms}, where
two–group comparisons were conducted using adaptive Metropolis sampling.
The present implementation generalizes that approach to more than two
groups and supports additional samplers (HMC and NUTS) with staged warmup
adaptation.

Key components of the model:
}
\section{Pairwise Interactions}{

For variables \eqn{i} and \eqn{j}, the group-specific interaction is
represented as:
\deqn{\theta_{ij}^{(g)} = \phi_{ij} + \delta_{ij}^{(g)},}
where \eqn{\phi_{ij}} is the baseline effect and
\eqn{\delta_{ij}^{(g)}} are group differences constrained to sum to zero.
}

\section{Ordinal Variables}{

\strong{Regular ordinal variables}: category thresholds are decomposed into a
baseline plus group differences for each category.

\strong{Blume–Capel variables}: category thresholds are quadratic in the
category index, with both the linear and quadratic terms split into a
baseline plus group differences.
}

\section{Variable Selection}{

When \code{difference_selection = TRUE}, spike-and-slab priors are
applied to difference parameters:
\itemize{
  \item \strong{Bernoulli}: fixed prior inclusion probability.
  \item \strong{Beta–Bernoulli}: inclusion probability given a Beta prior.
}
}

\section{Sampling Algorithms and Warmup}{

Parameters are updated within a Gibbs framework, using the same
sampling algorithms and staged warmup scheme described in
\code{\link{bgm}}:
\itemize{
  \item \strong{Adaptive Metropolis–Hastings}: componentwise random–walk
    proposals with Robbins–Monro adaptation of proposal SDs.
  \item \strong{Hamiltonian Monte Carlo (HMC)}: joint updates with fixed
    leapfrog trajectories; step size and optionally the mass matrix are
    adapted during warmup.
  \item \strong{No–U–Turn Sampler (NUTS)}: an adaptive HMC variant with
    dynamic trajectory lengths; warmup uses the same staged adaptation
    schedule as HMC.
}

For details on the staged adaptation schedule (fast–slow–fast phases),
see \code{\link{bgm}}. In addition, when
\code{difference_selection = TRUE}, updates of inclusion indicators are
delayed until late warmup. In HMC/NUTS, this appends two extra phases
(Stage-3b and Stage-3c), so that the total number of warmup iterations
exceeds the user-specified \code{warmup}.

After warmup, adaptation is disabled: step size and mass matrix are fixed
at their learned values, and proposal SDs remain constant.
}

\examples{
\dontrun{
# Run bgmCompare on subset of the Boredom dataset
x = Boredom[Boredom$language == "fr", 2:6]
y = Boredom[Boredom$language != "fr", 2:6]

fit <- bgmCompare(x, y)

# Posterior inclusion probabilities
summary(fit)$indicator

# Bayesian model averaged main effects for the groups
coef(fit)$main_effects_groups

# Bayesian model averaged pairwise effects for the groups
coef(fit)$pairwise_effects_groups
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{vignette("comparison", package = "bgms")} for a worked example.
}
