% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_country_standardized.R
\name{bdc_country_standardized}
\alias{bdc_country_standardized}
\title{Standardizes country names and gets country code}
\usage{
bdc_country_standardized(data, country = "country")
}
\arguments{
\item{data}{data.frame. Containing country names}

\item{country}{character string. The column name with the country assignment
of each record. Default = "country".}
}
\value{
A data.frame containing two columns: country_suggested (standardized
country names) and country_code (two-letter country codes; more details in
\href{https://github.com/stefangabos/world_countries/}{World Countries, International Organization for Standardization}).
}
\description{
This function standardizes country names and adds a new column to the
database containing two-letter country codes (ISO 3166-1 alpha-2).
}
\details{
Country names are standardized using an exact matching against a
list of country names in several languages from International Organization for Standardization. If any unmatched
names remain,  a fuzzy matching algorithm is used to find potential
candidates for each misspelled countries names.
}
\examples{
\dontrun{
country <- c("BOLIVIA", "bolivia", "Brasil", "Brazil", "BREZIL")
x <- data.frame(country)

bdc_country_standardized(
  data = x,
  country = "country"
)
}

}
\seealso{
Other prefilter: 
\code{\link{bdc_basisOfRecords_notStandard}()},
\code{\link{bdc_coordinates_country_inconsistent}()},
\code{\link{bdc_coordinates_empty}()},
\code{\link{bdc_coordinates_from_locality}()},
\code{\link{bdc_coordinates_outOfRange}()},
\code{\link{bdc_coordinates_transposed}()},
\code{\link{bdc_scientificName_empty}()}
}
\concept{prefilter}
