% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_smooth.R
\name{bayes_smooth}
\alias{bayes_smooth}
\title{Smooth probability images}
\usage{
bayes_smooth(x, window_size = 7, neigh_fraction = 0.5, smoothness = 10)
}
\arguments{
\item{x}{SpatRaster object with probabilities images}

\item{window_size}{Size of the neighborhood.}

\item{neigh_fraction}{Fraction of neighbors with high probabilities
to be used in Bayesian inference.}

\item{smoothness}{Estimated variance of logit of class probabilities
(Bayesian smoothing parameter). It can be either
a vector or a scalar.}
}
\value{
A SpatRaster object
}
\description{
Takes a classified image with probabilities, and reduces outliers
and smoothens probability according to Bayesian statistics
}
\examples{
if (bayes_run_examples()) {
    # select a file with probability values
    data_dir <- system.file("/extdata/probs/", package = "bayesEO")
    file <- list.files(data_dir)
    # create a full path for the file
    probs_file <- paste0(data_dir, "/", file)
    # provide the labels
    labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
             "ClearCut_Veg", "Forest", "Wetland")
    # read the probs file
    probs <- bayes_read_probs(probs_file, labels)
    # smooth the probability image
    probs_smooth <- bayes_smooth(probs,
            window_size = 7,
            smoothness = 20
    )
    # plot the probability image
    bayes_plot_probs(probs_smooth)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
